% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program Weibullcomp.m
function [chi2, p] = Weibullcomp(PFS)  
        % PFS contains the measured psychometric 
        % functions. Every three rows of PFS is a 
        % psychometric function

NPF = size(PFS, 1)/3;

% full model fit
fullmodel_maxloglikelihood=0;
for i = 1: NPF
        data =  PFS( (i-1)*3+1 : (i*3), :);
        guess = [0.02 3];   % tau eta
        options = optimset('fminsearch');
        [psy, minus_maxloglikelihood] = ...
              fminsearch('Weibullcostfunc', guess, ...
              options, data);
        maxloglikelihood = - minus_maxloglikelihood;
          
        fullmodel_maxloglikelihood = ...
              fullmodel_maxloglikelihood ...
              + maxloglikelihood;
end
  
% reduced model: same slope across all psychometric 
% functions
data = PFS;
guess = [0.02*ones(1, NPF) 3];
options = optimset('fminsearch');
[psy, minus_maxloglikelihood] = fminsearch('Weibullcomp_costfunc', guess, options, data);
reducedmodel_maxloglikelihood = - minus_maxloglikelihood;
 
chi2 = 2*(fullmodel_maxloglikelihood - ...
       reducedmodel_maxloglikelihood);
p = chi2cdf(chi2, NPF-1);
